<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_producto = $_GET['id_producto'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];


	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}


	$consulta1 = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, p.valor_impuesto, "VENTA" as tipo, v.created_at as fecha, v.precio_venta as precio, v.cantidad , v.precio_venta_total as total, ve.nombre_comprobante as comprobante, c.nombre as interesado, c.numero_documento as doc, u.nombres as nom_personal, u.apellidos as ap_personal, l.nombre as local FROM detalle_venta v INNER JOIN ventas ve ON ve.id_venta = v.id_venta INNER JOIN productos p ON p.id_producto = v.id_producto INNER JOIN clientes c ON c.id_cliente = ve.id_cliente INNER JOIN usuarios u ON u.id_usuario = ve.id_usuario INNER JOIN local l ON ve.id_local = l.id_local WHERE v.id_producto = "'.$id_producto.'" AND (v.created_at >= "'.$fecha1.' 00:00:00" AND v.created_at <= "'.$fecha2.' 23:59:59") AND ve.id_nota IS NULL AND ve.estado="1" ORDER BY v.id_venta';
	
	$consulta2 = 'SELECT p.nombre, p.codigo_barras, p.descripcion, p.lote, p.situacion_impuesto, p.valor_impuesto, "COMPRA" as tipo, d.created_at as fecha, d.precio_compra_unitario as precio, d.cantidad, d.precio_compra_total as total, c.numero_comprobante as comprobante, pro.nombre as interesado, pro.numero_documento as doc, u.nombres as nom_personal, u.apellidos as ap_personal, l.nombre as local FROM detalle_compra d INNER JOIN productos p ON p.id_producto = d.id_producto INNER JOIN compras c ON c.id_compra = d.id_compra INNER JOIN usuarios u ON u.id_usuario = c.id_usuario INNER JOIN proveedores pro ON c.id_proveedor = pro.id_proveedor INNER JOIN local l ON c.id_local = l.id_local WHERE d.id_producto = "'.$id_producto.'" AND (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND c.estado = 1 ORDER BY d.id_compra';


	$consulta3 = 'SELECT pr.nombre, pr.codigo_barras, pr.descripcion, pr.lote, pr.situacion_impuesto, pr.valor_impuesto, p.tipo as tipo, dp.created_at as fecha, dp.precio as precio, dp.cantidad , dp.subtotal as total, CONCAT(p.tipo , " Nº ", p.id_proforma ) as comprobante,  p.nombre as interesado, p.numero_documento as doc, u.nombres as nom_personal, u.apellidos as ap_personal, l.nombre as local FROM detalle_proforma dp INNER JOIN proformas p ON p.id_proforma = dp.id_proforma INNER JOIN productos pr ON pr.id_producto = dp.id_producto  INNER JOIN usuarios u ON u.id_usuario = p.id_usuario INNER JOIN local l ON p.id_local = l.id_local WHERE dp.id_producto = "'.$id_producto.'" AND (dp.created_at >= "'.$fecha1.' 00:00:00" AND dp.created_at <= "'.$fecha2.' 23:59:59") AND p.estado="1"  AND p.tipo="PEDIDO"  ORDER BY p.id_proforma';

	$consulta4 = 'SELECT pr.nombre, pr.codigo_barras, pr.descripcion, pr.lote, pr.situacion_impuesto, pr.valor_impuesto, "TRASLADO" AS tipo, dt.created_at as fecha, pr.precio as precio, dt.cantidad , (pr.precio*dt.cantidad) as total, CONCAT("TRASLADO Nº ", t.id_traslado) as comprobante,  l2.nombre as interesado, "" as doc, u.nombres as nom_personal, u.apellidos as ap_personal, l.nombre as local FROM traslados t INNER JOIN detalle_traslado dt ON t.id_traslado = dt.id_traslado INNER JOIN productos pr ON pr.id_producto = dt.id_producto INNER JOIN usuarios u ON u.id_usuario = t.id_usuario INNER JOIN local l ON t.id_local_origen = l.id_local INNER JOIN local l2 ON t.id_local_destino = l2.id_local WHERE dt.id_producto = "'.$id_producto.'" AND (t.created_at >= "'.$fecha1.' 00:00:00" AND t.created_at <= "'.$fecha2.' 23:59:59") AND t.estado="1" ORDER BY t.id_traslado';


	 
	$resultado1 = $conexion->query($consulta1);
	$resultado2 = $conexion->query($consulta2);
	$resultado3 = $conexion->query($consulta3);
	$resultado4 = $conexion->query($consulta4);

	if($resultado1->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de HISTORIAL DE PRODUCTOS")
									 ->setSubject("Reporte de HISTORIAL DE PRODUCTOS")
									 ->setDescription("Reporte de HISTORIAL DE PRODUCTOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:Q1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE HISTORIAL DEL PRODUCTO')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE DEL PRODUCTO')
		            ->setCellValue('C2', 'CODIGO BARRAS')
		            ->setCellValue('D2', 'LOTE / SERIE')
		            ->setCellValue('E2', 'MARCA')
					->setCellValue('F2', 'SITUACION DE IMPUESTO')
					->setCellValue('G2', 'VALOR IMPUESTO')
					->setCellValue('H2', 'TIPO DE MOVIMIENTO')
					->setCellValue('I2', 'CANTIDAD')
					->setCellValue('J2', 'PRECIO S/')
					->setCellValue('K2', 'TOTAL S/')
					->setCellValue('L2', 'N° COMPROBANTE')
					->setCellValue('M2', 'NOMBRE DE CLIENTE O PROVEEDOR O DESTINO')
					->setCellValue('N2', 'N° DOCUMENTO')
					->setCellValue('O2', 'PERSONAL QUE REGISTRÓ')
					->setCellValue('P2', 'FECHA')
					->setCellValue('Q2', 'SUCURSAL DONDE SE REGISTRÓ');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:Q2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(100);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(50);

        $i = 3; //Numero de fila donde se va a comenzar a rellenar
		$j = 1;
		while ($fila = $resultado1->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, $fila['codigo_barras'])
			    ->setCellValue('D'.$i, $fila['lote'])
			    ->setCellValue('E'.$i,  utf8_encode($fila['descripcion']))
			    ->setCellValue('F'.$i,  utf8_encode($fila['situacion_impuesto']))
			    ->setCellValue('G'.$i, $fila['valor_impuesto'])
			    ->setCellValue('H'.$i, $fila['tipo'])
			    ->setCellValue('I'.$i, $fila['cantidad'])
			    ->setCellValue('J'.$i, $fila['precio'])
			    ->setCellValue('K'.$i, $fila['total'])
			    ->setCellValue('L'.$i, $fila['comprobante'])
			    ->setCellValue('M'.$i, utf8_encode($fila['interesado']))
			    ->setCellValue('N'.$i, $fila['doc'])
			    ->setCellValue('O'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
			    ->setCellValue('P'.$i, $fila['fecha'])
			    ->setCellValue('Q'.$i, $fila['local']);
			$i++;
			$j++;
		}

		if($resultado2->num_rows > 0 ){
		
			while ($fila = $resultado2->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $j)
				    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
				    ->setCellValue('C'.$i, $fila['codigo_barras'])
				    ->setCellValue('D'.$i, $fila['lote'])
				    ->setCellValue('E'.$i,  utf8_encode($fila['descripcion']))
				    ->setCellValue('F'.$i,  utf8_encode($fila['situacion_impuesto']))
				    ->setCellValue('G'.$i, $fila['valor_impuesto'])
				    ->setCellValue('H'.$i, $fila['tipo'])
				    ->setCellValue('I'.$i, $fila['cantidad'])
				    ->setCellValue('J'.$i, $fila['precio'])
				    ->setCellValue('K'.$i, $fila['total'])
				    ->setCellValue('L'.$i, $fila['comprobante'])
				    ->setCellValue('M'.$i, utf8_encode($fila['interesado']))
				    ->setCellValue('N'.$i, $fila['doc'])
				    ->setCellValue('O'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
				    ->setCellValue('P'.$i, $fila['fecha'])
				    ->setCellValue('Q'.$i, $fila['local']);
				    $i++;
					$j++;
			}
		}


		if($resultado3->num_rows > 0 ){
		
			while ($fila = $resultado3->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $j)
				    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
				    ->setCellValue('C'.$i, $fila['codigo_barras'])
				    ->setCellValue('D'.$i, $fila['lote'])
				    ->setCellValue('E'.$i,  utf8_encode($fila['descripcion']))
				    ->setCellValue('F'.$i,  utf8_encode($fila['situacion_impuesto']))
				    ->setCellValue('G'.$i, $fila['valor_impuesto'])
				    ->setCellValue('H'.$i, $fila['tipo'])
				    ->setCellValue('I'.$i, $fila['cantidad'])
				    ->setCellValue('J'.$i, $fila['precio'])
				    ->setCellValue('K'.$i, $fila['total'])
				    ->setCellValue('L'.$i, $fila['comprobante'])
				    ->setCellValue('M'.$i, utf8_encode($fila['interesado']))
				    ->setCellValue('N'.$i, $fila['doc'])
				    ->setCellValue('O'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
				    ->setCellValue('P'.$i, $fila['fecha'])
				    ->setCellValue('Q'.$i, $fila['local']);
				$i++;
				$j++;
			}
		}

		if($resultado4->num_rows > 0 ){
		
			while ($fila = $resultado4->fetch_array()) {
				$objPHPExcel->setActiveSheetIndex(0)
				    ->setCellValue('A'.$i, $j)
				    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
				    ->setCellValue('C'.$i, $fila['codigo_barras'])
				    ->setCellValue('D'.$i, $fila['lote'])
				    ->setCellValue('E'.$i,  utf8_encode($fila['descripcion']))
				    ->setCellValue('F'.$i,  utf8_encode($fila['situacion_impuesto']))
				    ->setCellValue('G'.$i, $fila['valor_impuesto'])
				    ->setCellValue('H'.$i, $fila['tipo'])
				    ->setCellValue('I'.$i, $fila['cantidad'])
				    ->setCellValue('J'.$i, $fila['precio'])
				    ->setCellValue('K'.$i, $fila['total'])
				    ->setCellValue('L'.$i, $fila['comprobante'])
				    ->setCellValue('M'.$i, utf8_encode($fila['interesado']))
				    ->setCellValue('N'.$i, $fila['doc'])
				    ->setCellValue('O'.$i, utf8_encode($fila['nom_personal'].' '.$fila['ap_personal']))
				    ->setCellValue('P'.$i, $fila['fecha'])
				    ->setCellValue('Q'.$i, $fila['local']);
				$i++;
				$j++;
			}
		}


		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('K3:K'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "Q".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Historial Productos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Productos_Histo.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






