@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRO DE COMPRAS REALIZADAS AL CREDITO</h4>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Almacén</th>
                        <th class="head_table">Proveedor</th>
                        <th class="head_table">Fecha de Compra</th>
                        <th class="head_table">Fecha a Pagar</th>
                        <th class="head_table">Deuda S/</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $compra)
                    <tr data-table="{{ $compra->id_compra }}">
                        <td>{{ $i }}</td>
                        <td>{{ $compra->local->nombre }}</td>
                        <td>{{ $compra->proveedor->nombre }}</td>
                        <td>{{ $compra->created_at}}</td>
                        <td style="color: red">{{ $compra->fecha_pago }}</td>
                        <td>{{ $compra->total_compra }}</td>
                        <td>                            
                            {{-- <div class="ui mini vertical animated positive button button_info_modal" title="Ver informacion detallada" data-id="{{ $compra->id_compra }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </div> --}}
                            <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('compra/detalles_deuda/'.$compra->id_compra) }}">
                                <div class="hidden content">Detalles</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </a>
                           {{--  <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $compra->id_compra }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                            </div> --}}
                      
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


